{strip}

  <!-- Initialize -->
  <script>
    /* initialize vars */
    var site_title = "{__($system['system_title'])}";
    var site_path = "{$system['system_url']}";
    var ajax_path = site_path + "/includes/ajax/";
    var uploads_path = "{$system['system_uploads']}";
    var current_page = "{$page}";
    var system_debugging_mode = {if $system['DEBUGGING']}true{else}false{/if};
    var smooth_infinite_scroll = {if $system['smooth_infinite_scroll']}true{else}false{/if};
    var newsfeed_results = "{$system['newsfeed_results']}";
    /* language */
    var system_langauge_dir = "{strtolower($system['language']['dir'])}";
    var system_langauge_code = "{substr($system['language']['code'], 0, -3)}";
    /* datetime */
    var system_datetime_format = {if $system['system_datetime_format'] == "m/d/Y H:i"}'MM/DD/YYYY HH:mm'{else}'DD/MM/YYYY HH:mm'{/if};
    /* theme */
    var theme_mode_night = {if $system['theme_mode_night']}true{else}false{/if};
    var theme_dir_rtl = {if $system['language']['dir'] == "LTR"}false{else}true{/if};
    /* payments */
    var currency = "{$system['system_currency']}";
    var stripe_key = {if $system['stripe_mode'] == "live"}"{$system['stripe_live_publishable']}"{else}"{$system['stripe_test_publishable']}"{/if};
    var stripe_payment_element_enabled = {if $system['stripe_payment_element_enabled']}true{else}false{/if};
    var twocheckout_merchant_code = "{$system['2checkout_merchant_code']}";
    var twocheckout_publishable_key = "{$system['2checkout_publishable_key']}";
    var razorpay_key = "{$system['razorpay_key_id']}";
    var shift4_key = "{$system['shift4_api_key']}";
    var cashfree_mode = {if $system['cashfree_mode'] == "sandbox"}"sandbox"{else}"production"{/if};
    var epayco_key = "{$system['epayco_public_key']}";
    var epayco_test = {if $system['epayco_mode'] == "test"}true{else}false{/if};
    /* features */
    var adblock_detector = {if !$user->_is_admin && $system['adblock_detector_enabled']}true{else}false{/if};
    var location_finder = {if !$user->_is_admin && $system['location_finder_enabled']}true{else}false{/if};
    var desktop_infinite_scroll = {if $system['desktop_infinite_scroll']}true{else}false{/if};
    var mobile_infinite_scroll = {if $system['mobile_infinite_scroll']}true{else}false{/if};
    var fluid_videos_enabled = {if $system['fluid_videos_enabled']}true{else}false{/if};
    var auto_play_videos = {if $system['auto_play_videos']}true{else}false{/if};
    var disable_yt_player = {if $system['disable_yt_player']}true{else}false{/if};
    {if $user->_logged_in}
      /* user */
      var user_id = "{$user->_data['user_id']}";
      /* ajax */
      var min_data_heartbeat = "{$system['data_heartbeat']*1000}";
      var min_chat_heartbeat = "{$system['chat_heartbeat']*1000}";
      /* uploads */
      var secret = "{$secret}";
      var allow_heif_images = {if $system['allow_heif_images']}true{else}false{/if};
      var accpeted_image_extensions = ".png, .gif, .jpeg, .jpg, .webp";
      if (allow_heif_images) {
        accpeted_image_extensions += ", .heic, .heif";
      }
      var accpeted_video_extensions = "{$system['accpeted_video_extensions']}";
      var video_minimum_duration = "{$system['video_minimum_duration']}";
      var video_maximum_duration = "{$system['video_maximum_duration']}";
      var reels_minimum_duration = "{$system['reels_minimum_duration']}";
      var reels_maximum_duration = "{$system['reels_maximum_duration']}";
      var accpeted_audio_extensions = "{$system['accpeted_audio_extensions']}";
      var accpeted_file_extensions = "{$system['accpeted_file_extensions']}";
      var tinymce_photos_enabled = {if $system['tinymce_photos_enabled']}true{else}false{/if};
      var cover_crop_enabled = {if $system['cover_crop_enabled']}true{else}false{/if};
      var chunk_upload_size = "{$system['chunk_upload_size']}";
      /* chat */
      var chat_enabled = {if $system['chat_enabled'] && $user->_data['user_privacy_chat'] != "me"}true{else}false{/if};
      var chat_socket_enabled = {if $system['chat_socket_enabled']}true{else}false{/if};
      {if $system['chat_socket_enabled']}
        var chat_socket_port = "{$system['chat_socket_port']}";
        var chat_socket_path = window.location.protocol + "//" + window.location.hostname {if !$system['chat_socket_proxied']} + ":" + chat_socket_port{/if};
      {/if}
      {if $system['redirect_to_mobile_apps']}
        var messaging_app_android_link = "{$system['messaging_app_android_link']}";
        var messaging_app_ios_link = "{$system['messaging_app_ios_link']}";
      {/if}
      var chat_typing_enabled = {if $system['chat_typing_enabled']}true{else}false{/if};
      var chat_seen_enabled = {if $system['chat_seen_enabled']}true{else}false{/if};
      var chat_sound = {if $user->_data['chat_sound']}true{else}false{/if};
      /* audio/video calls */
      var audio_video_provider = "{$system['audio_video_provider']}";
      var livekit_ws_url = "{$system['livekit_ws_url']}";
      var agora_call_app_id = "{$system['agora_call_app_id']}";
      /* live */
      var live_enabled = {if $system['live_enabled']}true{else}false{/if};
      {if $system['live_enabled']}
        var agora_app_id = "{$system['agora_app_id']}";
        {if $page == "live"}
          var agora_uid = {$agora['uid']};
          var agora_token = "{$agora['token']}";
          var agora_channel_name = "{$agora['channel_name']}";
        {/if}
      {/if}
      /* notifications */
      var notifications_sound = {if $user->_data['notifications_sound']}true{else}false{/if};
      var noty_notifications_enabled = {if $system['noty_notifications_enabled']}true{else}false{/if};
      var browser_notifications_enabled = {if $system['browser_notifications_enabled']}true{else}false{/if};
      /* stories */
      {if $system['stories_enabled']}
        var stories_duration = "{$system['stories_duration']}";
      {/if}
      /* posts */
      var daytime_msg_enabled = {if $daytime_msg_enabled}true{else}false{/if};
      var giphy_key = "{$system['giphy_key']}";
      var geolocation_enabled = {if $system['geolocation_enabled']}true{else}false{/if};
      var google_translation_key = "{$system['google_translation_key']}";
      var yandex_key = "{$system['yandex_key']}";
      var post_translation_enabled = {if $system['post_translation_enabled']}true{else}false{/if};
      var chat_translation_enabled = {if $system['chat_translation_enabled']}true{else}false{/if};
      var voice_notes_durtaion = "{$system['voice_notes_durtaion']}";
      var voice_notes_encoding = "{$system['voice_notes_encoding']}";
    {/if}
  </script>
  <script>
    /* i18n for JS */
    var __ = [];
    __['Ask something'] = `{__('Ask something')}`;
    __['Add Friend'] = `{__('Add Friend')}`;
    __['Friends'] = `{__('Friends')}`; 
    __['Sent'] = `{__('Sent')}`;
    __['Following'] = `{__('Following')}`;
    __['Follow'] = `{__('Follow')}`;
    __['Pending'] = `{__('Pending')}`;
    __['Remove'] = `{__('Remove')}`;
    __['Error'] = `{__('Error')}`;
    __['Loading'] = `{__('Loading')}`;
    __['Like'] = `{__('Like')}`;
    __['Unlike'] = `{__('Unlike')}`;
    __['React'] = `{__('React')}`;
    __['Joined'] = `{__('Joined')}`;
    __['Join'] = `{__('Join')}`;
    __['Remove Admin'] = `{__('Remove Admin')}`;
    __['Make Admin'] = `{__('Make Admin')}`;
    __['Going'] = `{__('Going')}`;
    __['Interested'] = `{__('Interested')}`;
    __['Delete'] = `{__('Delete')}`;
    __['Delete Cover'] = `{__('Delete Cover')}`;
    __['Delete Picture'] = `{__('Delete Picture')}`;
    __['Delete Post'] = `{__('Delete Post')}`;
    __['Delete Comment'] = `{__('Delete Comment')}`;
    __['Delete Conversation'] = `{__('Delete Conversation')}`;
    __['Block User'] = `{__('Block User')}`;
    __['Unblock User'] = `{__('Unblock User')}`;
    __['Mark as Available'] = `{__('Mark as Available')}`;
    __['Mark as Sold'] = `{__('Mark as Sold')}`;
    __['Save Post'] = `{__('Save Post')}`;
    __['Unsave Post'] = `{__('Unsave Post')}`;
    __['Boost Post'] = `{__('Boost Post')}`;
    __['Unboost Post'] = `{__('Unboost Post')}`;
    __['Pin Post'] = `{__('Pin Post')}`;
    __['Unpin Post'] = `{__('Unpin Post')}`;
    __['For Everyone'] = `{__('For Everyone')}`;
    __['For Subscribers Only'] = `{__('For Subscribers Only')}`;
    __['Verify'] = `{__('Verify')}`;
    __['Decline'] = `{__('Decline')}`;
    __['Boost'] = `{__('Boost')}`;
    __['Unboost'] = `{__('Unboost')}`;
    __['Mark as Paid'] = `{__('Mark as Paid')}`;
    __['Read more'] = `{__('Read more')}`;
    __['Read less'] = `{__('Read less')}`;
    __['Turn On Active Status'] = `{__('Turn On Active Status')}`;
    __['Turn Off Active Status'] = `{__('Turn Off Active Status')}`;
    __['Monthly Average'] = `{__('Monthly Average')}`;
    __['PayIn Methods'] = `{__('PayIn Methods')}`;
    __['PayIn Types'] = `{__('PayIn Types')}`;
    __['Commissions Types'] = `{__('Commissions Types')}`;
    __['Packages'] = `{__('Packages')}`;
    __['Jan'] = `{__('Jan')}`;
    __['Feb'] = `{__('Feb')}`;
    __['Mar'] = `{__('Mar')}`;
    __['Apr'] = `{__('Apr')}`;
    __['May'] = `{__('May')}`;
    __['Jun'] = `{__('Jun')}`;
    __['Jul'] = `{__('Jul')}`;
    __['Aug'] = `{__('Aug')}`;
    __['Sep'] = `{__('Sep')}`;
    __['Oct'] = `{__('Oct')}`;
    __['Nov'] = `{__('Nov')}`;
    __['Dec'] = `{__('Dec')}`;
    __['Users'] = `{__('Users')}`;
    __['Pages'] = `{__('Pages')}`;
    __['Groups'] = `{__('Groups')}`;
    __['Events'] = `{__('Events')}`;
    __['Posts'] = `{__('Posts')}`;
    __['Translated'] = `{__('Translated')}`;
    __['Are you sure you want to delete this?'] = `{__('Are you sure you want to delete this?')}`;
    __['Are you sure you want to remove your cover photo?'] = `{__('Are you sure you want to remove your cover photo?')}`;
    __['Are you sure you want to remove your profile picture?'] = `{__('Are you sure you want to remove your profile picture?')}`;
    __['Are you sure you want to delete this post?'] = `{__('Are you sure you want to delete this post?')}`;
    __['Are you sure you want to delete this comment?'] = `{__('Are you sure you want to delete this comment?')}`;
    __['Are you sure you want to delete this conversation?'] = `{__('Are you sure you want to delete this conversation?')}`;
    __['Are you sure you want to block this user?'] = `{__('Are you sure you want to block this user?')}`;
    __['Are you sure you want to unblock this user?'] = `{__('Are you sure you want to unblock this user?')}`;
    __['Are you sure you want to delete your account?'] = `{__('Are you sure you want to delete your account?')}`;
    __['Are you sure you want to verify this request?'] = `{__('Are you sure you want to verify this request?')}`;
    __['Are you sure you want to decline this request?'] = `{__('Are you sure you want to decline this request?')}`;
    __['Are you sure you want to approve this request?'] = `{__('Are you sure you want to approve this request?')}`;
    __['Are you sure you want to do this?'] = `{__('Are you sure you want to do this?')}`;
    __['Factory Reset'] = `{__('Factory Reset')}`;
    __['Reset API Key'] = `{__('Reset API Key')}`;
    __['Reset JWT Key'] = `{__('Reset JWT Key')}`;
    __['Are you sure you want to reset your website?'] = `{__('Are you sure you want to reset your website?')}`;
    __['Are you sure you want to reset your API key?'] = `{__('Are you sure you want to reset your API key?')}`;
    __['Are you sure you want to reset your JWT key?'] = `{__('Are you sure you want to reset your JWT key?')}`;
    __['There is something that went wrong!'] = `{__('There is something that went wrong!')}`;
    __['There is no more data to show'] = `{__('There is no more data to show')}`;
    __['This website uses cookies to ensure you get the best experience on our website'] = `{__('This website uses cookies to ensure you get the best experience on our website')}`;
    __['Got It!'] = `{__('Got It!')}`;
    __['Learn More'] = `{__('Learn More')}`;
    __['No result found'] = `{__('No result found')}`;
    __['Turn on Commenting'] = `{__('Turn on Commenting')}`;
    __['Turn off Commenting'] = `{__('Turn off Commenting')}`;
    __['Day Mode'] = `{__('Day Mode')}`;
    __['Night Mode'] = `{__('Night Mode')}`;
    __['Message'] = `{__('Message')}`;
    __['You haved poked'] = `{__('You haved poked')}`;
    __['Touch to unmute'] = `{__('Touch to unmute')}`;
    __['Press space to see next'] = `{__('Press space to see next')}`;
    __['Visit link'] = `{__('Visit link')}`;
    __['ago'] = `{__('ago')}`;
    __['hour'] = `{__('hour')}`;
    __['hours'] = `{__('hours')}`;
    __['minute'] = `{__('minute')}`;
    __['minutes'] = `{__('minutes')}`;
    __['from now'] = `{__('from now')}`;
    __['seconds'] = `{__('seconds')}`;
    __['yesterday'] = `{__('yesterday')}`;
    __['tomorrow'] = `{__('tomorrow')}`;
    __['days'] = `{__('days')}`;
    __['Seen by'] = `{__('Seen by')}`;
    __['Ringing'] = `{__('Ringing')}`;
    __['is Offline'] = `{__('is Offline')}`;
    __['is Busy'] = `{__('is Busy')}`;
    __['No Answer'] = `{__('No Answer')}`;
    __['You can not connect to this user'] = `{__('You can not connect to this user')}`;
    __['You have an active call already'] = `{__('You have an active call already')}`;
    __['Declined the call'] = `{__('Declined the call')}`;
    __['Connection has been lost'] = `{__('Connection has been lost')}`;
    __['You must fill in all of the fields'] = `{__('You must fill in all of the fields')}`;
    __['Hide from Timeline'] = `{__('Hide from Timeline')}`;
    __['Allow on Timeline'] = `{__('Allow on Timeline')}`;
    __['Are you sure you want to hide this post from your profile timeline? It may still appear in other places like newsfeed and search results'] = `{__('Are you sure you want to hide this post from your profile timeline? It may still appear in other places like newsfeed and search results')}`;
    __['Total'] = `{__('Total')}`;
    __['Stop Campaign'] = `{__('Stop Campaign')}`;
    __['Resume Campaign'] = `{__('Resume Campaign')}`;
    __['Sorry, WebRTC is not available in your browser'] = `{__('Sorry, WebRTC is not available in your browser')}`;
    __['Not able to connect, Try again later!'] = `{__('Not able to connect, Try again later!')}`;
    __['You are ready to Go Live now'] = `{__('You are ready to Go Live now')}`;
    __['Getting permissions failed'] = `{__('Getting permissions failed')}`;
    __['Going Live'] = `{__('Going Live')}`;
    __['You are live now'] = `{__('You are live now')}`;
    __['You are offline now'] = `{__('You are offline now')}`;
    __['Online'] = `{__('Online')}`;
    __['Offline'] = `{__('Offline')}`;
    __['Video Muted'] = `{__('Video Muted')}`;
    __['Audio Muted'] = `{__('Audio Muted')}`;
    __['Live Ended'] = `{__('Live Ended')}`;
    __['Try Package'] = `{__('Try Package')}`;
    __['Are you sure you want to subscribe to this free package?'] = `{__('Are you sure you want to subscribe to this free package?')}`;
    __['Sneak Peak'] = `{__('Sneak Peak')}`;
    __['Are you sure you want to subscribe to this free plan?'] = `{__('Are you sure you want to subscribe to this free plan?')}`;
    __['Processing'] = `{__('Processing')}`;
    __['Your video is being processed, We will let you know when it is ready!'] = `{__('Your video is being processed, We will let you know when it is ready!')}`;
    __['Under Review'] = `{__('Under Review')}`;
    __['Your post is under review now, We will let you know when it is ready!'] = `{__('Your post is under review now, We will let you know when it is ready!')}`;
    __['Payment Confirmation'] = `{__('Payment Confirmation')}`;
    __['This message will cost you'] = `{__('This message will cost you')}`;
    __['This call will cost you'] = `{__('This call will cost you')}`;
    __['Login As'] = `{__('Login As')}`;
    __['Are you sure you want to login as this user?'] = `{__('Are you sure you want to login as this user?')}`;
    __['Are you sure you want to switch back to your account?'] = `{__('Are you sure you want to switch back to your account?')}`;
    __['Your video is too short, it must be at least'] = `{__('Your video is too short, it must be at least')}`;
    __['Your video is too long, it must be at most'] = `{__('Your video is too long, it must be at most')}`;
    /* i18n for DataTables */
    __['Processing...'] = `{__('Processing...')}`;
    __['Search:'] = `{__('Search:')}`;
    __['Show _MENU_ entries'] = `{__('Show _MENU_ entries')}`;
    __['Showing _START_ to _END_ of _TOTAL_ entries'] = `{__('Showing _START_ to _END_ of _TOTAL_ entries')}`;
    __['Showing 0 to 0 of 0 entries'] = `{__('Showing 0 to 0 of 0 entries')}`;
    __['(filtered from _MAX_ total entries)'] = `{__('(filtered from _MAX_ total entries)')}`;
    __['Loading...'] = `{__('Loading...')}`;
    __['No matching records found'] = `{__('No matching records found')}`;
    __['No data available in table'] = `{__('No data available in table')}`;
    __['First'] = `{__('First')}`;
    __['Previous'] = `{__('Previous')}`;
    __['Next'] = `{__('Next')}`;
    __['Last'] = `{__('Last')}`;
    __[': activate to sort column ascending'] = `{__(': activate to sort column ascending')}`;
    __[': activate to sort column descending'] = `{__(': activate to sort column descending')}`;
    /* i18n for OneSignal */
    __['Subscribe to notifications'] = `{__('Subscribe to notifications')}`;
    __['You are subscribed to notifications'] = `{__('You are subscribed to notifications')}`;
    __['You have blocked notifications'] = `{__('You have blocked notifications')}`;
    __['Click to subscribe to notifications'] = `{__('Click to subscribe to notifications')}`;
    __['Thanks for subscribing!'] = `{__('Thanks for subscribing!')}`;
    __['You are subscribed to notifications'] = `{__('You are subscribed to notifications')}`;
    __['You will not receive notifications again'] = `{__('You will not receive notifications again')}`;
    __['Manage Site Notifications'] = `{__('Manage Site Notifications')}`;
    __['SUBSCRIBE'] = `{__('SUBSCRIBE')}`;
    __['UNSUBSCRIBE'] = `{__('UNSUBSCRIBE')}`;
    __['Unblock Notifications'] = `{__('Unblock Notifications')}`;
    __['Follow these instructions to allow notifications:'] = `{__('Follow these instructions to allow notifications:')}`;
    /* i18n for Video Player */
    __['Play'] = `{__('Play')}`;
    __['Pause'] = `{__('Pause')}`;
    __['Mute'] = `{__('Mute')}`;
    __['Unmute'] = `{__('Unmute')}`;
    __['Current Time'] = `{__('Current Time')}`;
    __['Duration'] = `{__('Duration')}`;
    __['Remaining Time'] = `{__('Remaining Time')}`;
    __['Fullscreen'] = `{__('Fullscreen')}`;
    __['Picture-in-Picture'] = `{__('Picture-in-Picture')}`;
    /* i18n for Highcharts.js */
    __['View Fullscreen'] = `{__('View Fullscreen')}`;
    __['Print Chart'] = `{__('Print Chart')}`;
    __['Download PNG'] = `{__('Download PNG')}`;
    __['Download JPEG'] = `{__('Download JPEG')}`;
    __['Download PDF'] = `{__('Download PDF')}`;
    __['Download SVG vector image'] = `{__('Download SVG vector image')}`;
    __['Chart context menu'] = `{__('Chart context menu')}`;
  </script>
  <!-- Initialize -->

  <!-- Dependencies Libs [Bootstrap|jQuery|jQueryUI] -->
  <script src="{$system['system_url']}/node_modules/bootstrap/dist/js/bootstrap.bundle.min.js"></script>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.14.1/jquery-ui.min.js"></script>

  <script src="{$system['system_url']}/node_modules/@benmajor/jquery-touch-events/src/jquery.mobile-events.min.js"></script>
  <!-- Dependencies Libs [Bootstrap|jQuery|jQueryUI] -->

  <!-- Dependencies Plugins -->
  <script src="{$system['system_url']}/node_modules/mustache/mustache.min.js" {if !$user->_logged_in}defer{/if}>
    
  </script>
  <script src="{$system['system_url']}/node_modules/jquery-form/dist/jquery.form.min.js" {if !$user->_logged_in}defer{/if}>
    
  </script>
  <script src="{$system['system_url']}/node_modules/jquery-inview/jquery.inview.min.js" {if !$user->_logged_in}defer{/if}>
    
  </script>
  <script src="{$system['system_url']}/node_modules/autosize/dist/autosize.min.js" {if !$user->_logged_in}defer{/if}>
    
  </script>
  <script src="{$system['system_url']}/node_modules/readmore-js/readmore.min.js" {if !$user->_logged_in}defer{/if}>
    
  </script>
  <script src="{$system['system_url']}/node_modules/moment/min/moment-with-locales.min.js" {if !$user->_logged_in}defer{/if}>
    
  </script>
  <script src="https://cdn.plyr.io/3.8.3/plyr.js" {if !$user->_logged_in}defer{/if}>
    
  </script>
  <script src="https://cdn.jsdelivr.net/npm/hls.js@latest" {if !$user->_logged_in}defer{/if}>
    
  </script>
  <link rel="stylesheet" href="https://cdn.plyr.io/3.7.8/plyr.css" {if !$user->_logged_in}defer{/if} />

  {if $system['auto_play_videos']}
    <script src="{$system['system_url']}/node_modules/jquery-fracs/dist/jquery.fracs.min.js" {if !$user->_logged_in}defer{/if}>
      
    </script>
  {/if}

  {if $user->_logged_in}
    <!-- triggeredAutocomplete -->
    <script src="{$system['system_url']}/node_modules/triggeredautocomplete/jquery-ui.triggeredAutocomplete.js"></script>
    <!-- triggeredAutocomplete -->

    <!-- Sticky Sidebar -->
    <script src="{$system['system_url']}/node_modules/theia-sticky-sidebar/dist/theia-sticky-sidebar.min.js"></script>
    <!-- Sticky Sidebar -->

    <!-- Google Geocomplete -->
    {if $system['geolocation_enabled']}
      <script src="https://cdnjs.cloudflare.com/ajax/libs/geocomplete/1.7.0/jquery.geocomplete.min.js" integrity="sha512-4bp4fE4hv0i/1jLM7d+gXDaCAhnXXfGBKdHrBcpGBgnz7OlFMjUgVH4kwB85YdumZrZyryaTLnqGKlbmBatCpQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
      <script src="https://maps.googleapis.com/maps/api/js?libraries=places&key={$system['geolocation_key']}&loading=async"></script>
    {/if}
    <!-- Google Geocomplete -->

    <!-- Crop Profile Picture & Reposition Cover Photo -->
    {if in_array($page, ["started", "profile", "page", "group", "event"])}
      <script src="{$system['system_url']}/node_modules/jquery-ui-touch-punch/jquery.ui.touch-punch.min.js"></script>
      <script src="{$system['system_url']}/node_modules/JQ-Image-Drag/script/jquery.imagedrag.min.js"></script>
      <script src="{$system['system_url']}/node_modules/rcrop/dist/rcrop.min.js"></script>
      <link rel="stylesheet" type='text/css' href="{$system['system_url']}/node_modules/rcrop/dist/rcrop.min.css">
    {/if}
    <!-- Crop Profile Picture & Reposition Cover Photo -->

    <!-- Stories -->
    {if $page == "index" && $view == ""}
      <script src="{$system['system_url']}/node_modules/zuck.js/dist/zuck.min.js"></script>
      <link rel="stylesheet" type='text/css' href="{$system['system_url']}/node_modules/zuck.js/dist/zuck.min.css">
    {/if}
    <!-- Stories -->

    <!-- Voice Notes -->
    {if $system['voice_notes_posts_enabled'] || $system['voice_notes_comments_enabled'] || $system['voice_notes_chat_enabled']}
      <script src="{$system['system_url']}/node_modules/web-audio-recorder-js/lib-minified/WebAudioRecorder.min.js"></script>
    {/if}
    <!-- Voice Notes -->

    <!-- TinyMCE -->
    {if in_array($page, ["admin", "blogs", "forums", "support"])}
      <script src="{$system['system_url']}/node_modules/tinymce/tinymce.min.js" defer></script>
    {/if}
    <!-- TinyMCE -->

    <!-- Stripe & 2Checkout & Razorpay & Shift4 & Cashfree & Epayco -->
    {if in_array($page, ["index", "packages", "ads", "wallet", "market", "profile", "page", "group", "post", "directory", "search", "movies"])}
      {if $system['creditcard_enabled'] || $system['alipay_enabled']}
        <script src="https://js.stripe.com/v3" defer></script>
      {/if}
      {if $system['2checkout_enabled']}
        <script src="https://www.2checkout.com/checkout/api/2co.min.js" defer></script>
      {/if}
      {if $system['razorpay_enabled']}
        <script src="https://checkout.razorpay.com/v1/checkout.js" defer></script>
      {/if}
      {if $system['shift4_enabled']}
        <script src="https://js.dev.shift4.com/checkout.js" defer></script>
      {/if}
      {if $system['cashfree_enabled']}
        <script src="https://sdk.cashfree.com/js/v3/cashfree.js" defer></script>
      {/if}
      {if $system['epayco_enabled']}
        <script src="https://checkout.epayco.co/checkout.js" defer></script>
      {/if}
    {/if}
    <!-- Stripe & 2Checkout & Razorpay & Shift4 & Cashfree & Epayco -->
	
	<!-- (Twillio|LiveKit) [Audio/Video Calls] -->
    {if $system['audio_call_enabled'] || $system['video_call_enabled']}
      {if $system['audio_video_provider'] == "twilio"}
        <script src="https://sdk.twilio.com/js/video/releases/2.33.0/twilio-video.min.js" defer></script>
      {/if}
      {if $system['audio_video_provider'] == "livekit"}
        <script src="https://cdn.jsdelivr.net/npm/livekit-client/dist/livekit-client.umd.min.js" defer></script>
      {/if}
    {/if}
    <!-- (Twillio|LiveKit) [Audio/Video Calls] -->

    <!-- Agora [Live Streaming & Audio/Video Calls] -->
    {if $system['live_enabled'] || $system['audio_video_provider'] == 'agora'}
      <script src="https://download.agora.io/sdk/release/AgoraRTC_N-4.24.0.js"></script>
    {/if}
    <!-- Agora [Live Streaming & Audio/Video Calls] -->

    <!-- Easytimer -->
    {if $system['audio_call_enabled'] || $system['video_call_enabled'] || $system['voice_notes_posts_enabled'] || $system['voice_notes_comments_enabled'] || $system['voice_notes_chat_enabled']}
      <script src="{$system['system_url']}/node_modules/easytimer.js/dist/easytimer.min.js" defer></script>
    {/if}
    <!-- Easytimer -->
	
	<!-- Datatables -->
    {if in_array($page, ["admin", "ads", "wallet", "developers", "settings"])}
      <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.3.5/css/dataTables.bootstrap5.min.css" defer />
      <script src="https://cdn.datatables.net/2.3.5/js/dataTables.js" defer></script>
      <script src="https://cdn.datatables.net/2.3.5/js/dataTables.bootstrap5.min.js" defer></script>
    {/if}
    <!-- Datatables -->

    <!-- Tagify -->
	{if in_array($page, ["admin", "packages", "settings", "blogs"]) || ($system['merits_enabled'] && in_array($page, ['index', 'profile']))}
      <script src="{$system['system_url']}/node_modules/@yaireo/tagify/dist/tagify.js" defer></script>
      <link rel="stylesheet" type='text/css' href="{$system['system_url']}//node_modules/@yaireo/tagify/dist/tagify.css" defer>
    {/if}
    <!-- Tagify -->

    <!-- HTML2PDF -->
    {if $page == "market"}
      <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.12.1/html2pdf.bundle.min.js" defer></script>
    {/if}
    <!-- HTML2PDF -->

    <!-- Clipboard -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/2.0.11/clipboard.min.js" integrity="sha512-7O5pXpc0oCRrxk8RUfDYFgn0nO1t+jLuIOQdOMRp4APB7uZ4vSjspzp5y6YDtDs4VzUSTbWzBFZ/LKJhnyFOKw==" crossorigin="anonymous" referrerpolicy="no-referrer" defer></script>
    <!-- Clipboard -->

    <!-- XRegExp -->
    <script src="https://cdn.jsdelivr.net/npm/xregexp@5.1.2/xregexp-all.js" defer></script>
    <!-- XRegExp -->
  {/if}
  <!-- Dependencies Plugins -->

  <!-- System [JS] -->
  <script src="{$system['system_url']}/includes/assets/js/core/core.js?v={$system['system_version']}-{filemtime('includes/assets/js/core/core.js')}" {if !$user->_logged_in}defer{/if}>
    
  </script>
  {if $user->_logged_in}
    <script src="{$system['system_url']}/includes/assets/js/core/user.js?v={$system['system_version']}-{filemtime('includes/assets/js/core/user.js')}"></script>
    <script src="{$system['system_url']}/includes/assets/js/core/post.js?v={$system['system_version']}-{filemtime('includes/assets/js/core/post.js')}"></script>
    {if $system['chat_enabled']}
      {if $system['chat_socket_enabled']}
        {if $system['chat_socket_server'] == "php"}
          <script src="https://cdnjs.cloudflare.com/ajax/libs/socket.io/2.5.0/socket.io.js"></script>
        {/if}
        {if $system['chat_socket_server'] == "nodejs"}
          <script src="https://cdnjs.cloudflare.com/ajax/libs/socket.io/4.8.1/socket.io.js"></script>
        {/if}
      {/if}
      <script src="{$system['system_url']}/includes/assets/js/core/chat.js?v={$system['system_version']}-{filemtime('includes/assets/js/core/chat.js')}"></script>
    {/if}
    <script src="{$system['system_url']}/includes/assets/js/core/ad_code.js?v={$system['system_version']}-{filemtime('includes/assets/js/core/ad_code.js')}"></script>
    {if $system['live_enabled'] && $page == "live"}
      <script src="{$system['system_url']}/includes/assets/js/core/live.js?v={$system['system_version']}-{filemtime('includes/assets/js/core/live.js')}"></script>
    {/if}
  {else}
    <script src="{$system['system_url']}/includes/assets/js/core/login.js?v={$system['system_version']}-{filemtime('includes/assets/js/core/login.js')}" defer></script>
  {/if}
  <!-- System [JS] -->
  
	<script type="text/javascript">
		document.querySelectorAll('.dropdownUserMenuButton').forEach(button => {
			button.addEventListener('show.bs.dropdown', function () {
				document.querySelector('body').classList.add('user_menu_open');
			});

			button.addEventListener('hide.bs.dropdown', function () {
				document.querySelector('body').classList.remove('user_menu_open');
			});
		});
		
		document.querySelectorAll('.dropdownMoreMenuButton').forEach(button => {
			button.addEventListener('show.bs.dropdown', function () {
				document.querySelector('body').classList.add('more_menu_open');
			});

			button.addEventListener('hide.bs.dropdown', function () {
				document.querySelector('body').classList.remove('more_menu_open');
			});
		});
		
		document.querySelectorAll('.dropdownMenuButton').forEach(button => {
			button.addEventListener('show.bs.dropdown', function () {
				const dropdownMenu = this.nextElementSibling;
				document.querySelector('.x-sidebar-width').appendChild(dropdownMenu);
			});

			button.addEventListener('hide.bs.dropdown', function () {
				const dropdownMenu = this.nextElementSibling;
				this.parentNode.appendChild(dropdownMenu);
			});
		});

		document.addEventListener('DOMContentLoaded', function () {
			const slider = document.querySelector('.x_page_scroll .scrolll');
			const leftBtn = document.querySelector('.scroll-left-btn');
			const rightBtn = document.querySelector('.scroll-right-btn');
			const scrollAmount = 200;
			
			if (!slider || !leftBtn || !rightBtn) {
				return;
			}

			function checkButtonVisibility() {
				leftBtn.style.display = slider.scrollLeft > 0 ? 'flex' : 'none';
				const maxScroll = slider.scrollWidth - slider.clientWidth;
				rightBtn.style.display = slider.scrollLeft < maxScroll ? 'flex' : 'none';
			}

			leftBtn.addEventListener('click', function () {
				slider.scrollBy({ left: -scrollAmount, behavior: 'smooth' });
				setTimeout(checkButtonVisibility, 200); // Check after animation
			});

			rightBtn.addEventListener('click', function () {
				slider.scrollBy({ left: scrollAmount, behavior: 'smooth' });
				setTimeout(checkButtonVisibility, 200); // Check after animation
			});

			checkButtonVisibility();
			slider.addEventListener('scroll', checkButtonVisibility);
			
			slider.addEventListener('wheel', (evt) => {
				evt.preventDefault();
				slider.scrollLeft += evt.deltaY;
			});
		});
	</script>
	
	{if $user->_logged_in}
		<script type="text/javascript">
			function x_addSpecial(code, input) {
				tareaTag = $(input);
				tareaVal = tareaTag.val();
				if(typeof (tareaTag.attr('placeholder')) != "undefined") {
					inputPlaceholder = tareaTag.attr('placeholder');
					if(inputPlaceholder == tareaVal) {
						tareaTag.val('');
						tareaVal = tareaTag.val();
					}
				}
				if(tareaVal.length == 0) {
					tareaTag.val(code);
				} else {
					tareaTag.val(tareaVal + ' ' + code);
				}
				tareaTag.keyup().focus();
			}
			
			$(document).on('click','.x_menu_sidebar_back',function(){
				setTimeout(function() {
					$('body').addClass('show_menu_sidebar');
				}, 100);
				$('.x_menu_sidebar_content').fadeOut(100);
			});
			
			$(document).on('click','.x_menu_content_back',function(){
				$('body').removeClass('show_menu_sidebar');
				$('.x_menu_sidebar_content').fadeIn(100);
			});
			
			$(document).on('click','.x_menu_sidebar.x_side_msg_bar .x_menu_content_back',function(){
				$('.x_menu_sidebar.x_side_msg_bar').removeClass('no_hide');
				$('body').removeClass('show_menu_sidebar');
				$('.x_menu_sidebar_content').fadeIn(100);
			});
			
			var didScroll;
			var lastScrollTop = 0;
			var delta = 5;
			var navbarHeight = $('.logo-wrapper').outerHeight();

			$(window).scroll(function(event){
				didScroll = true;
			});

			setInterval(function() {
				if (didScroll) {
					hasScrolled();
					didScroll = false;
				}
			}, 250);

			function hasScrolled() {
				var st = $(this).scrollTop();
				if(Math.abs(lastScrollTop - st) <= delta)
					return;
				if (st > lastScrollTop && st > navbarHeight){
					$('body').addClass('scroll_down');
				} else {
					if(st + $(window).height() < $(document).height()) {
						$('body').removeClass('scroll_down');
					}
				}
				lastScrollTop = st;
			}
			
			$('body').on('click', '.js_live-requests, .js_live-messages', function () {
				var _this = $(this);
				var counter = parseInt(_this.find("span.counter").text()) || 0;
				if (counter > 0) {
				  /* reset the client counter & hide it */
				  _this.find("span.counter").text('0').hide();
				  /* get the reset target */
				  if (_this.hasClass('js_live-requests')) {
					var data = { 'reset': 'friend_requests' };
				  } else if (_this.hasClass('js_live-messages')) {
					var data = { 'reset': 'messages' };
				  }
				  /* reset the server counter */
				  $.post(api['data/reset'], data, function (response) {
					/* check the response */
					if (!response) return;
					/* check if there is a callback */
					if (response.callback) {
					  eval(response.callback);
					}
				  }, 'json')
					.fail(function () {
					  modal('#modal-message', { title: __['Error'], message: __['There is something that went wrong!'] });
					});
				}
			  });
		</script>
	{/if}

  {if $page == "admin"}
    <!-- Dependencies Plugins -->
    <script src="{$system['system_url']}/node_modules/jquery-treegrid/js/jquery.treegrid.min.js"></script>
    <link rel="stylesheet" type='text/css' href="{$system['system_url']}/node_modules/jquery-treegrid/css/jquery.treegrid.css">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/codemirror.min.js" integrity="sha512-8RnEqURPUc5aqFEN04aQEiPlSAdE0jlFS/9iGgUyNtwFnSKCXhmB6ZTNl7LnDtDWKabJIASzXrzD0K+LYexU9g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/mode/css/css.min.js" integrity="sha512-rQImvJlBa8MV1Tl1SXR5zD2bWfmgCEIzTieFegGg89AAt7j/NBEe50M5CqYQJnRwtkjKMmuYgHBqtD1Ubbk5ww==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/mode/javascript/javascript.min.js" integrity="sha512-I6CdJdruzGtvDyvdO4YsiAq+pkWf2efgd1ZUSK2FnM/u2VuRASPC7GowWQrWyjxCZn6CT89s3ddGI+be0Ak9Fg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/6.65.7/codemirror.min.css" integrity="sha512-uf06llspW44/LZpHzHT6qBOIVODjWtv4MxCricRxkzvopAlSWnTf6hpZTFxuuZcuNE9CBQhqE0Seu1CoRk84nQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Dependencies Plugins [JS] -->

    <!-- System [JS] -->
    <script src="{$system['system_url']}/includes/assets/js/core/admin.js?v={$system['system_version']}-{filemtime('includes/assets/js/core/admin.js')}"></script>
    <!-- System [JS] -->

    <!-- Admin Charts -->
    <script src="https://code.highcharts.com/highcharts.js"></script>
    <script src="https://code.highcharts.com/modules/exporting.js"></script>
    {if $view == "dashboard"}
      <script>
        $(function() {
          $('#admin-chart-dashboard').highcharts({
            lang: {
              viewFullscreen: __['View Fullscreen'],
              printChart: __['Print Chart'],
              downloadPNG: __['Download PNG'],
              downloadJPEG: __['Download JPEG'],
              downloadPDF: __['Download PDF'],
              downloadSVG: __['Download SVG vector image'],
              contextButtonTitle: __['Chart context menu'],
            },
            chart: {
              type: 'column',
              backgroundColor: 'transparent',
            },
            title: {
              text: __['Monthly Average']
            },
            xAxis: {
              categories: [
                __['Jan'],
                __['Feb'],
                __['Mar'],
                __['Apr'],
                __['May'],
                __['Jun'],
                __['Jul'],
                __['Aug'],
                __['Sep'],
                __['Oct'],
                __['Nov'],
                __['Dec']
              ],
              crosshair: true
            },
            yAxis: {
              min: 0,
              title: {
                text: __['Total']
              }
            },
            tooltip: {
              headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
              pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
              '<td style="padding:0"><b>{literal}{point.y}{/literal}</b></td></tr>',
              footerFormat: '</table>',
              shared: true,
              useHTML: true
            },
            plotOptions: {
              column: {
                pointPadding: 0.2,
                borderWidth: 0
              }
            },
            series: [{
                name: __['Users'],
                data: [{$chart['users']|join:","}]
              },
              {
                name: __['Pages'],
                data: [{$chart['pages']|join:","}]
              },
              {
                name: __['Groups'],
                data: [{$chart['groups']|join:","}]
              },
              {
                name: __['Events'],
                data: [{$chart['events']|join:","}]
              },
              {
                name: __['Posts'],
                data: [{$chart['posts']|join:","}]
              }
            ]
          });
        });
      </script>
    {/if}
    {if $view == "earnings" && $sub_view == ""}
      <script>
        $(function() {
          $('#payment-methods-chart').highcharts({
            lang: {
              viewFullscreen: __['View Fullscreen'],
              printChart: __['Print Chart'],
              downloadPNG: __['Download PNG'],
              downloadJPEG: __['Download JPEG'],
              downloadPDF: __['Download PDF'],
              downloadSVG: __['Download SVG vector image'],
              contextButtonTitle: __['Chart context menu'],
            },
            chart: {
              type: 'column',
              backgroundColor: 'transparent',
            },
            title: {
              text: __['PayIn Methods']
            },
            xAxis: {
              categories: [
                __['Jan'],
                __['Feb'],
                __['Mar'],
                __['Apr'],
                __['May'],
                __['Jun'],
                __['Jul'],
                __['Aug'],
                __['Sep'],
                __['Oct'],
                __['Nov'],
                __['Dec']
              ],
              crosshair: true
            },
            yAxis: {
              min: 0,
              title: {
                text: __['Total'] + ' ' + '(' + currency + ')'
              }
            },
            tooltip: {
              headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
              pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
              '<td style="padding:0"><b>{literal}{point.y}{/literal}</b></td></tr>',
              footerFormat: '</table>',
              shared: true,
              useHTML: true
            },
            plotOptions: {
              column: {
                pointPadding: 0.2,
                borderWidth: 0
              }
            },
            series: [
              {foreach $payment_methods as $method}
                {
                  name: '{$method|capitalize}',
                  data: [
                    {foreach $payment_methods_chart as $month => $payments}
                      {$payments[$method]},
                    {/foreach}
                  ]
                },
              {/foreach}
            ]
          });
          $('#payment-handles-chart').highcharts({
            lang: {
              viewFullscreen: __['View Fullscreen'],
              printChart: __['Print Chart'],
              downloadPNG: __['Download PNG'],
              downloadJPEG: __['Download JPEG'],
              downloadPDF: __['Download PDF'],
              downloadSVG: __['Download SVG vector image'],
              contextButtonTitle: __['Chart context menu'],
            },
            chart: {
              type: 'column',
              backgroundColor: 'transparent',
            },
            title: {
              text: __['PayIn Types']
            },
            xAxis: {
              categories: [
                __['Jan'],
                __['Feb'],
                __['Mar'],
                __['Apr'],
                __['May'],
                __['Jun'],
                __['Jul'],
                __['Aug'],
                __['Sep'],
                __['Oct'],
                __['Nov'],
                __['Dec']
              ],
              crosshair: true
            },
            yAxis: {
              min: 0,
              title: {
                text: __['Total'] + ' ' + '(' + currency + ')'
              }
            },
            tooltip: {
              headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
              pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
              '<td style="padding:0"><b>{literal}{point.y}{/literal}</b></td></tr>',
              footerFormat: '</table>',
              shared: true,
              useHTML: true
            },
            plotOptions: {
              column: {
                pointPadding: 0.2,
                borderWidth: 0
              }
            },
            series: [
              {foreach $payment_handles as $handle}
                {
                  name: '{$handle|capitalize}',
                  data: [
                    {foreach $payment_handles_chart as $month => $payments}
                      {$payments[$handle]},
                    {/foreach}
                  ]
                },
              {/foreach}
            ]
          });
        });
      </script>
    {/if}
    {if $view == "earnings" && $sub_view == "commissions"}
      <script>
        $(function() {
          $('#commissions-chart').highcharts({
            lang: {
              viewFullscreen: __['View Fullscreen'],
              printChart: __['Print Chart'],
              downloadPNG: __['Download PNG'],
              downloadJPEG: __['Download JPEG'],
              downloadPDF: __['Download PDF'],
              downloadSVG: __['Download SVG vector image'],
              contextButtonTitle: __['Chart context menu'],
            },
            chart: {
              type: 'column',
              backgroundColor: 'transparent',
            },
            title: {
              text: __['Commissions Types']
            },
            xAxis: {
              categories: [
                __['Jan'],
                __['Feb'],
                __['Mar'],
                __['Apr'],
                __['May'],
                __['Jun'],
                __['Jul'],
                __['Aug'],
                __['Sep'],
                __['Oct'],
                __['Nov'],
                __['Dec']
              ],
              crosshair: true
            },
            yAxis: {
              min: 0,
              title: {
                text: __['Total'] + ' ' + '(' + currency + ')'
              }
            },
            tooltip: {
              headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
              pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
              '<td style="padding:0"><b>{literal}{point.y}{/literal}</b></td></tr>',
              footerFormat: '</table>',
              shared: true,
              useHTML: true
            },
            plotOptions: {
              column: {
                pointPadding: 0.2,
                borderWidth: 0
              }
            },
            series: [
              {foreach $commissions_handles as $handle}
                {
                  name: '{$handle|capitalize}',
                  data: [
                    {foreach $commissions_handles_chart as $month => $commissions}
                      {$commissions[$handle]},
                    {/foreach}
                  ]
                },
              {/foreach}
            ]
          });
        });
      </script>
    {/if}
    {if $view == "earnings" && $sub_view == "packages"}
      <script>
        $(function() {
          $('#admin-chart-earnings').highcharts({
            lang: {
              viewFullscreen: __['View Fullscreen'],
              printChart: __['Print Chart'],
              downloadPNG: __['Download PNG'],
              downloadJPEG: __['Download JPEG'],
              downloadPDF: __['Download PDF'],
              downloadSVG: __['Download SVG vector image'],
              contextButtonTitle: __['Chart context menu'],
            },
            chart: {
              type: 'column',
              backgroundColor: 'transparent',
            },
            title: {
              text: __['Packages']
            },
            xAxis: {
              categories: [
                __['Jan'],
                __['Feb'],
                __['Mar'],
                __['Apr'],
                __['May'],
                __['Jun'],
                __['Jul'],
                __['Aug'],
                __['Sep'],
                __['Oct'],
                __['Nov'],
                __['Dec']
              ],
              crosshair: true
            },
            yAxis: {
              min: 0,
              title: {
                text: __['Total'] + ' ' + '(' + currency + ')'
              }
            },
            tooltip: {
              headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
              pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
              '<td style="padding:0"><b>{literal}{point.y}{/literal}</b></td></tr>',
              footerFormat: '</table>',
              shared: true,
              useHTML: true
            },
            plotOptions: {
              column: {
                pointPadding: 0.2,
                borderWidth: 0
              }
            },
            series: [
              {foreach $rows as $key => $value}
                {
                  name: "{$key}",
                  data: [{$value['months_sales']|join:","}]
                },
              {/foreach}
            ]
          });

        });
      </script>
    {/if}
    <!-- Admin Charts -->

    <!-- Admin Code Editor -->
    {if $view == "design"}
      <script>
        $(function() {
          CodeMirror.fromTextArea(document.getElementById('custome_js_header'), {
            mode: "javascript",
            lineNumbers: true,
            readOnly: false
          });

          CodeMirror.fromTextArea(document.getElementById('custome_js_footer'), {
            mode: "javascript",
            lineNumbers: true,
            readOnly: false
          });

          CodeMirror.fromTextArea(document.getElementById('custom-css'), {
            mode: "css",
            lineNumbers: true,
            readOnly: false
          });
        });
      </script>
    {/if}
    {if $view == "settings" && $sub_view == "uploads"}
      <script>
        $(function() {
          $('.nav-tabs a').on('shown.bs.tab', function() {
            cm.refresh();
          });
          cm = CodeMirror.fromTextArea(document.getElementById('google_cloud_file'), {
            mode: "javascript",
            lineNumbers: true,
            readOnly: false
          });
        });
      </script>
    {/if}
    <!-- Admin Code Editor -->
  {/if}

  <!-- Cookies Policy -->
  {if $system['cookie_consent_enabled']}
    <script src="//cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.0.3/cookieconsent.min.js" {if !$user->_logged_in}defer{/if}>
      
    </script>
    <link rel="stylesheet" type="text/css" href="//cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.0.3/cookieconsent.min.css" />
    <script>
      window.addEventListener("load", function() {
        window.cookieconsent.initialise({
          "palette": {
            "popup": {
              "background": "#1e2321",
              "text": "#fff"
            },
            "button": {
              "background": "#5e72e4"
            }
          },
          "theme": "edgeless",
          "position": {if $system['language']['dir'] == 'LTR'}"bottom-left"{else}"bottom-right"{/if},
          "content": {
            "message": __['This website uses cookies to ensure you get the best experience on our website'],
            "dismiss": __['Got It!'],
            "link": __['Learn More'],
            "href": site_path + "/static/privacy"
          }
        })
      });
    </script>
  {/if}
  <!-- Cookies Policy -->

  <!-- OneSignal Notifications -->
  {if $user->_logged_in && $page != "reels" && $system['onesignal_notification_enabled']}
    <script src="https://cdn.onesignal.com/sdks/OneSignalSDK.js" async=""></script>
    <script>
      var onesignal_app_id = "{$system['onesignal_app_id']}";
      var onesignal_user_id = "{$user->_data['onesignal_user_id']}";
      var onesignal_push_id = "";
      var OneSignal = window.OneSignal || [];

      function saveAndroidOneSignalUserId(onesignal_user_id) {
        $.post(api['users/push_notifications'], { handle: 'update_android', id: onesignal_user_id });
      }

      function saveIOSOneSignalUserId(onesignal_user_id) {
        $.post(api['users/push_notifications'], { handle: 'update_ios', id: onesignal_user_id });
      }

      OneSignal.push(function() {
        OneSignal.init({
          appId: onesignal_app_id,
          autoResubscribe: false,
          notifyButton: {
            enable: true,
            /* Required to use the Subscription Bell */
            size: 'medium',
            /* One of 'small', 'medium', or 'large' */
            theme: 'default',
            /* One of 'default' (red-white) or 'inverse" (white-red) */
            position: (theme_dir_rtl) ? 'bottom-right' : 'bottom-left',
            /* Either 'bottom-left' or 'bottom-right' */
            offset: {
              bottom: '100px',
              left: '20px',
              /* Only applied if bottom-left */
              right: '20px' /* Only applied if bottom-right */
            },
            prenotify: true,
            /* Show an icon with 1 unread message for first-time site visitors */
            showCredit: false,
            /* Hide the OneSignal logo */
            text: {
              'tip.state.unsubscribed': __['Subscribe to notifications'],
              'tip.state.subscribed': __['You are subscribed to notifications'],
              'tip.state.blocked': __['You have blocked notifications'],
              'message.prenotify': __['Click to subscribe to notifications'],
              'message.action.subscribed': __['Thanks for subscribing!'],
              'message.action.resubscribed': __['You are subscribed to notifications'],
              'message.action.unsubscribed': __['You will not receive notifications again'],
              'dialog.main.title': __['Manage Site Notifications'],
              'dialog.main.button.subscribe': __['SUBSCRIBE'],
              'dialog.main.button.unsubscribe': __['UNSUBSCRIBE'],
              'dialog.blocked.title': __['Unblock Notifications'],
              'dialog.blocked.message': __['Follow these instructions to allow notifications:']
            },
            colors: {
              'circle.background': 'rgb(84,110,123)',
              'circle.foreground': 'white',
              'badge.background': 'rgb(84,110,123)',
              'badge.foreground': 'white',
              'badge.bordercolor': 'white',
              'pulse.color': 'white',
              'dialog.button.background.hovering': 'rgb(77, 101, 113)',
              'dialog.button.background.active': 'rgb(70, 92, 103)',
              'dialog.button.background': 'rgb(84,110,123)',
              'dialog.button.foreground': 'white'
            },
          },
          allowLocalhostAsSecureOrigin: true,
        });
        OneSignal.getUserId(function(userId) {
          onesignal_push_id = userId;
          if (userId != onesignal_user_id) {
            $.post(api['users/push_notifications'], { handle: 'update', id: onesignal_push_id });
          }
        });
        OneSignal.on('subscriptionChange', function(isSubscribed) {
          if (isSubscribed == false) {
            $.post(api['users/push_notifications'], { handle: 'delete' });
          } else {
            $.post(api['users/push_notifications'], { handle: 'update', id: onesignal_push_id });
          }
        });
      });
    </script>
  {/if}
  <!-- OneSignal Notifications -->

  <!-- Mouse Right Click Disabled -->
  {if $system['right_click_disabled']}
    <script>
      document.addEventListener('contextmenu', event => event.preventDefault());
    </script>
  {/if}
  <!-- Mouse Right Click Disabled -->

{/strip}